<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rekalkulacija ServiceType
 * @subpackage Services
 */
class Rekalkulacija extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rekalkulacijaNarudzbe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RekalkulacijaNarudzbe $parameters
     * @return \StructType\RekalkulacijaNarudzbeResponse|bool
     */
    public function rekalkulacijaNarudzbe(\StructType\RekalkulacijaNarudzbe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rekalkulacijaNarudzbe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RekalkulacijaNarudzbeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
