<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kontrola ServiceType
 * @subpackage Services
 */
class Kontrola extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kontrolaKupona
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KontrolaKupona $parameters
     * @return \StructType\KontrolaKuponaResponse|bool
     */
    public function kontrolaKupona(\StructType\KontrolaKupona $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kontrolaKupona($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KontrolaKuponaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
