<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Izmjena ServiceType
 * @subpackage Services
 */
class Izmjena extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named izmjenaNazivaAkcije
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IzmjenaNazivaAkcije $parameters
     * @return \StructType\IzmjenaNazivaAkcijeResponse|bool
     */
    public function izmjenaNazivaAkcije(\StructType\IzmjenaNazivaAkcije $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->izmjenaNazivaAkcije($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IzmjenaNazivaAkcijeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
