<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dohvati ServiceType
 * @subpackage Services
 */
class Dohvati extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named dohvatiIskoristivePogodnosti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiIskoristivePogodnosti $parameters
     * @return \StructType\DohvatiIskoristivePogodnostiResponse|bool
     */
    public function dohvatiIskoristivePogodnosti(\StructType\DohvatiIskoristivePogodnosti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiIskoristivePogodnosti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiPoklonBon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiPoklonBon $parameters
     * @return \StructType\DohvatiPoklonBonResponse|bool
     */
    public function dohvatiPoklonBon(\StructType\DohvatiPoklonBon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiPoklonBon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiLopClana
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiLopClana $parameters
     * @return \StructType\DohvatiLopClanaResponse|bool
     */
    public function dohvatiLopClana(\StructType\DohvatiLopClana $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiLopClana($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiNaruceneProizvode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiNaruceneProizvode $parameters
     * @return \StructType\DohvatiNaruceneProizvodeResponse|bool
     */
    public function dohvatiNaruceneProizvode(\StructType\DohvatiNaruceneProizvode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiNaruceneProizvode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiProizvode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiProizvode $parameters
     * @return \StructType\DohvatiProizvodeResponse|bool
     */
    public function dohvatiProizvode(\StructType\DohvatiProizvode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiProizvode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiRacun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiRacun $parameters
     * @return \StructType\DohvatiRacunResponse|bool
     */
    public function dohvatiRacun(\StructType\DohvatiRacun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiRacun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiZalihePoslovnica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiZalihePoslovnica $parameters
     * @return \StructType\DohvatiZalihePoslovnicaResponse|bool
     */
    public function dohvatiZalihePoslovnica(\StructType\DohvatiZalihePoslovnica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiZalihePoslovnica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiPlacenoPoPnB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiPlacenoPoPnB $parameters
     * @return \StructType\DohvatiPlacenoPoPnBResponse|bool
     */
    public function dohvatiPlacenoPoPnB(\StructType\DohvatiPlacenoPoPnB $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiPlacenoPoPnB($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiSifruNoveAkcije
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiSifruNoveAkcije $parameters
     * @return \StructType\DohvatiSifruNoveAkcijeResponse|bool
     */
    public function dohvatiSifruNoveAkcije(\StructType\DohvatiSifruNoveAkcije $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiSifruNoveAkcije($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiLopClanove
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiLopClanove $parameters
     * @return \StructType\DohvatiLopClanoveResponse|bool
     */
    public function dohvatiLopClanove(\StructType\DohvatiLopClanove $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiLopClanove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiDostavnaMjesta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiDostavnaMjesta $parameters
     * @return \StructType\DohvatiDostavnaMjestaResponse|bool
     */
    public function dohvatiDostavnaMjesta(\StructType\DohvatiDostavnaMjesta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiDostavnaMjesta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiPogodnosti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiPogodnosti $parameters
     * @return \StructType\DohvatiPogodnostiResponse|bool
     */
    public function dohvatiPogodnosti(\StructType\DohvatiPogodnosti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiPogodnosti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiArtikleSkolskeSezone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiArtikleSkolskeSezone $parameters
     * @return \StructType\DohvatiArtikleSkolskeSezoneResponse|bool
     */
    public function dohvatiArtikleSkolskeSezone(\StructType\DohvatiArtikleSkolskeSezone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiArtikleSkolskeSezone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiSlikeProizvoda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiSlikeProizvoda $parameters
     * @return \StructType\DohvatiSlikeProizvodaResponse|bool
     */
    public function dohvatiSlikeProizvoda(\StructType\DohvatiSlikeProizvoda $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiSlikeProizvoda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiKategorije
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiKategorije $parameters
     * @return \StructType\DohvatiKategorijeResponse|bool
     */
    public function dohvatiKategorije(\StructType\DohvatiKategorije $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiKategorije($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiStatusNaloga
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiStatusNaloga $parameters
     * @return \StructType\DohvatiStatusNalogaResponse|bool
     */
    public function dohvatiStatusNaloga(\StructType\DohvatiStatusNaloga $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiStatusNaloga($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiListuAkcija
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiListuAkcija $parameters
     * @return \StructType\DohvatiListuAkcijaResponse|bool
     */
    public function dohvatiListuAkcija(\StructType\DohvatiListuAkcija $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiListuAkcija($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiPoslovnice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiPoslovnice $parameters
     * @return \StructType\DohvatiPoslovniceResponse|bool
     */
    public function dohvatiPoslovnice(\StructType\DohvatiPoslovnice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiPoslovnice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiEftPosUredaje
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiEftPosUredaje $parameters
     * @return \StructType\DohvatiEftPosUredajeResponse|bool
     */
    public function dohvatiEftPosUredaje(\StructType\DohvatiEftPosUredaje $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiEftPosUredaje($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiZalihuArtikla
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiZalihuArtikla $parameters
     * @return \StructType\DohvatiZalihuArtiklaResponse|bool
     */
    public function dohvatiZalihuArtikla(\StructType\DohvatiZalihuArtikla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiZalihuArtikla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiRaspoloziveZalihe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiRaspoloziveZalihe $parameters
     * @return \StructType\DohvatiRaspoloziveZaliheResponse|bool
     */
    public function dohvatiRaspoloziveZalihe(\StructType\DohvatiRaspoloziveZalihe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiRaspoloziveZalihe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiCijeneProizvoda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiCijeneProizvoda $parameters
     * @return \StructType\DohvatiCijeneProizvodaResponse|bool
     */
    public function dohvatiCijeneProizvoda(\StructType\DohvatiCijeneProizvoda $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiCijeneProizvoda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dohvatiPartnere
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiPartnere $parameters
     * @return \StructType\DohvatiPartnereResponse|bool
     */
    public function dohvatiPartnere(\StructType\DohvatiPartnere $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->dohvatiPartnere($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DohvatiArtikleSkolskeSezoneResponse|\StructType\DohvatiCijeneProizvodaResponse|\StructType\DohvatiDostavnaMjestaResponse|\StructType\DohvatiEftPosUredajeResponse|\StructType\DohvatiIskoristivePogodnostiResponse|\StructType\DohvatiKategorijeResponse|\StructType\DohvatiListuAkcijaResponse|\StructType\DohvatiLopClanaResponse|\StructType\DohvatiLopClanoveResponse|\StructType\DohvatiNaruceneProizvodeResponse|\StructType\DohvatiPartnereResponse|\StructType\DohvatiPlacenoPoPnBResponse|\StructType\DohvatiPogodnostiResponse|\StructType\DohvatiPoklonBonResponse|\StructType\DohvatiPoslovniceResponse|\StructType\DohvatiProizvodeResponse|\StructType\DohvatiRacunResponse|\StructType\DohvatiRaspoloziveZaliheResponse|\StructType\DohvatiSifruNoveAkcijeResponse|\StructType\DohvatiSlikeProizvodaResponse|\StructType\DohvatiStatusNalogaResponse|\StructType\DohvatiZalihePoslovnicaResponse|\StructType\DohvatiZalihuArtiklaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
