<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dohvat ServiceType
 * @subpackage Services
 */
class Dohvat extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DohvatAtributa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatAtributa $parameters
     * @return \StructType\DohvatAtributaResponse|bool
     */
    public function DohvatAtributa(\StructType\DohvatAtributa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DohvatAtributa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DohvatAtributaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
