<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAkcija ArrayType
 * @subpackage Arrays
 */
class ArrayOfAkcija extends AbstractStructArrayBase
{
    /**
     * The Akcija
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Akcija[]
     */
    public $Akcija;
    /**
     * Constructor method for ArrayOfAkcija
     * @uses ArrayOfAkcija::setAkcija()
     * @param \StructType\Akcija[] $akcija
     */
    public function __construct(array $akcija = array())
    {
        $this
            ->setAkcija($akcija);
    }
    /**
     * Get Akcija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Akcija[]|null
     */
    public function getAkcija()
    {
        return isset($this->Akcija) ? $this->Akcija : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAkcija method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAkcija method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAkcijaForArrayConstraintsFromSetAkcija(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAkcijaAkcijaItem) {
            // validation for constraint: itemType
            if (!$arrayOfAkcijaAkcijaItem instanceof \StructType\Akcija) {
                $invalidValues[] = is_object($arrayOfAkcijaAkcijaItem) ? get_class($arrayOfAkcijaAkcijaItem) : sprintf('%s(%s)', gettype($arrayOfAkcijaAkcijaItem), var_export($arrayOfAkcijaAkcijaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Akcija property can only contain items of type \StructType\Akcija, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Akcija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Akcija[] $akcija
     * @return \ArrayType\ArrayOfAkcija
     */
    public function setAkcija(array $akcija = array())
    {
        // validation for constraint: array
        if ('' !== ($akcijaArrayErrorMessage = self::validateAkcijaForArrayConstraintsFromSetAkcija($akcija))) {
            throw new \InvalidArgumentException($akcijaArrayErrorMessage, __LINE__);
        }
        if (is_null($akcija) || (is_array($akcija) && empty($akcija))) {
            unset($this->Akcija);
        } else {
            $this->Akcija = $akcija;
        }
        return $this;
    }
    /**
     * Add item to Akcija value
     * @throws \InvalidArgumentException
     * @param \StructType\Akcija $item
     * @return \ArrayType\ArrayOfAkcija
     */
    public function addToAkcija(\StructType\Akcija $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Akcija) {
            throw new \InvalidArgumentException(sprintf('The Akcija property can only contain items of type \StructType\Akcija, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Akcija[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Akcija|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Akcija|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Akcija|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Akcija|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Akcija|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Akcija
     */
    public function getAttributeName()
    {
        return 'Akcija';
    }
}
