<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserByUniqueId StructType
 * @subpackage Structs
 */
class GetUserByUniqueId extends AbstractStructBase
{
    /**
     * The UniqueId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueId;
    /**
     * The AttributeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AttributeType;
    /**
     * Constructor method for GetUserByUniqueId
     * @uses GetUserByUniqueId::setUniqueId()
     * @uses GetUserByUniqueId::setAttributeType()
     * @param string $uniqueId
     * @param string $attributeType
     */
    public function __construct($uniqueId = null, $attributeType = null)
    {
        $this
            ->setUniqueId($uniqueId)
            ->setAttributeType($attributeType);
    }
    /**
     * Get UniqueId value
     * @return string|null
     */
    public function getUniqueId()
    {
        return $this->UniqueId;
    }
    /**
     * Set UniqueId value
     * @param string $uniqueId
     * @return \StructType\GetUserByUniqueId
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uniqueId)), __LINE__);
        }
        $this->UniqueId = $uniqueId;
        return $this;
    }
    /**
     * Get AttributeType value
     * @return string|null
     */
    public function getAttributeType()
    {
        return $this->AttributeType;
    }
    /**
     * Set AttributeType value
     * @param string $attributeType
     * @return \StructType\GetUserByUniqueId
     */
    public function setAttributeType($attributeType = null)
    {
        // validation for constraint: string
        if (!is_null($attributeType) && !is_string($attributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attributeType)), __LINE__);
        }
        $this->AttributeType = $attributeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserByUniqueId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
