<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Sets the StratogSecureSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\StratogSecureSoapHeader $stratogSecureSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderStratogSecureSoapHeader(\StructType\StratogSecureSoapHeader $stratogSecureSoapHeader, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'StratogSecureSoapHeader', $stratogSecureSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named IsUserLoggedIn
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsUserLoggedIn $parameters
     * @return \StructType\IsUserLoggedInResponse|bool
     */
    public function IsUserLoggedIn(\StructType\IsUserLoggedIn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IsUserLoggedIn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsValidRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IsValidRequest $parameters
     * @return \StructType\IsValidRequestResponse|bool
     */
    public function IsValidRequest(\StructType\IsValidRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IsValidRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IsUserLoggedInResponse|\StructType\IsValidRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
