<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAttribute ArrayType
 * @subpackage Arrays
 */
class ArrayOfAttribute extends AbstractStructArrayBase
{
    /**
     * The Attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attribute[]
     */
    public $Attribute;
    /**
     * Constructor method for ArrayOfAttribute
     * @uses ArrayOfAttribute::setAttribute()
     * @param \StructType\Attribute[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get Attribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attribute[]|null
     */
    public function getAttribute()
    {
        return isset($this->Attribute) ? $this->Attribute : null;
    }
    /**
     * Set Attribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute[] $attribute
     * @return \ArrayType\ArrayOfAttribute
     */
    public function setAttribute(array $attribute = array())
    {
        foreach ($attribute as $arrayOfAttributeAttributeItem) {
            // validation for constraint: itemType
            if (!$arrayOfAttributeAttributeItem instanceof \StructType\Attribute) {
                throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of \StructType\Attribute, "%s" given', is_object($arrayOfAttributeAttributeItem) ? get_class($arrayOfAttributeAttributeItem) : gettype($arrayOfAttributeAttributeItem)), __LINE__);
            }
        }
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->Attribute);
        } else {
            $this->Attribute = $attribute;
        }
        return $this;
    }
    /**
     * Add item to Attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute $item
     * @return \ArrayType\ArrayOfAttribute
     */
    public function addToAttribute(\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The Attribute property can only contain items of \StructType\Attribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attribute[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Attribute|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Attribute|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Attribute|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Attribute|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Attribute|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Attribute
     */
    public function getAttributeName()
    {
        return 'Attribute';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAttribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
