<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.rcog.org.uk/CustomServices/stratogAuthService.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.rcog.org.uk/CustomServices/stratogAuthService.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
$authenticate->setSoapHeaderStratogSecureSoapHeader(new \StructType\StratogSecureSoapHeader());
/**
 * Sample call for Authenticate operation/method
 */
if ($authenticate->Authenticate(new \StructType\Authenticate()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderStratogSecureSoapHeader(new \StructType\StratogSecureSoapHeader());
/**
 * Sample call for GetAttributeLookupValuesWithCodes operation/method
 */
if ($get->GetAttributeLookupValuesWithCodes(new \StructType\GetAttributeLookupValuesWithCodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserByUniqueId operation/method
 */
if ($get->GetUserByUniqueId(new \StructType\GetUserByUniqueId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetIndividualRefByAttributeCode operation/method
 */
if ($get->GetIndividualRefByAttributeCode(new \StructType\GetIndividualRefByAttributeCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetIndividualRefByAttributeDescription operation/method
 */
if ($get->GetIndividualRefByAttributeDescription(new \StructType\GetIndividualRefByAttributeDescription()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserByToken operation/method
 */
if ($get->GetUserByToken(new \StructType\GetUserByToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserStatus operation/method
 */
if ($get->GetUserStatus(new \StructType\GetUserStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMemberRoles operation/method
 */
if ($get->GetMemberRoles(new \StructType\GetMemberRoles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllCountries operation/method
 */
if ($get->GetAllCountries(new \StructType\GetAllCountries()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
$is->setSoapHeaderStratogSecureSoapHeader(new \StructType\StratogSecureSoapHeader());
/**
 * Sample call for IsUserLoggedIn operation/method
 */
if ($is->IsUserLoggedIn(new \StructType\IsUserLoggedIn()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for IsValidRequest operation/method
 */
if ($is->IsValidRequest(new \StructType\IsValidRequest()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Terminate ServiceType
 */
$terminate = new \ServiceType\Terminate($options);
$terminate->setSoapHeaderStratogSecureSoapHeader(new \StructType\StratogSecureSoapHeader());
/**
 * Sample call for Terminate operation/method
 */
if ($terminate->Terminate(new \StructType\Terminate()) !== false) {
    print_r($terminate->getResult());
} else {
    print_r($terminate->getLastError());
}
