<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryFile StructType
 * @subpackage Structs
 */
class CountryFile extends AbstractStructBase
{
    /**
     * The CountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The ISOCountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ISOCountryName;
    /**
     * Constructor method for CountryFile
     * @uses CountryFile::setCountryName()
     * @uses CountryFile::setCountryCode()
     * @uses CountryFile::setISOCountryName()
     * @param string $countryName
     * @param string $countryCode
     * @param string $iSOCountryName
     */
    public function __construct($countryName = null, $countryCode = null, $iSOCountryName = null)
    {
        $this
            ->setCountryName($countryName)
            ->setCountryCode($countryCode)
            ->setISOCountryName($iSOCountryName);
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\CountryFile
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\CountryFile
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ISOCountryName value
     * @return string|null
     */
    public function getISOCountryName()
    {
        return $this->ISOCountryName;
    }
    /**
     * Set ISOCountryName value
     * @param string $iSOCountryName
     * @return \StructType\CountryFile
     */
    public function setISOCountryName($iSOCountryName = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCountryName) && !is_string($iSOCountryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSOCountryName)), __LINE__);
        }
        $this->ISOCountryName = $iSOCountryName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CountryFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
