<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the StratogSecureSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\StratogSecureSoapHeader $stratogSecureSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderStratogSecureSoapHeader(\StructType\StratogSecureSoapHeader $stratogSecureSoapHeader, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'StratogSecureSoapHeader', $stratogSecureSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetAttributeLookupValuesWithCodes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttributeLookupValuesWithCodes $parameters
     * @return \StructType\GetAttributeLookupValuesWithCodesResponse|bool
     */
    public function GetAttributeLookupValuesWithCodes(\StructType\GetAttributeLookupValuesWithCodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAttributeLookupValuesWithCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserByUniqueId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserByUniqueId $parameters
     * @return \StructType\GetUserByUniqueIdResponse|bool
     */
    public function GetUserByUniqueId(\StructType\GetUserByUniqueId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserByUniqueId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIndividualRefByAttributeCode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIndividualRefByAttributeCode $parameters
     * @return \StructType\GetIndividualRefByAttributeCodeResponse|bool
     */
    public function GetIndividualRefByAttributeCode(\StructType\GetIndividualRefByAttributeCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIndividualRefByAttributeCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetIndividualRefByAttributeDescription
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIndividualRefByAttributeDescription $parameters
     * @return \StructType\GetIndividualRefByAttributeDescriptionResponse|bool
     */
    public function GetIndividualRefByAttributeDescription(\StructType\GetIndividualRefByAttributeDescription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIndividualRefByAttributeDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserByToken
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserByToken $parameters
     * @return \StructType\GetUserByTokenResponse|bool
     */
    public function GetUserByToken(\StructType\GetUserByToken $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserByToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserStatus $parameters
     * @return \StructType\GetUserStatusResponse|bool
     */
    public function GetUserStatus(\StructType\GetUserStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMemberRoles
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMemberRoles $parameters
     * @return \StructType\GetMemberRolesResponse|bool
     */
    public function GetMemberRoles(\StructType\GetMemberRoles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMemberRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllCountries
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: StratogSecureSoapHeader
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\StratogSecureSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllCountries $parameters
     * @return \StructType\GetAllCountriesResponse|bool
     */
    public function GetAllCountries(\StructType\GetAllCountries $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllCountriesResponse|\StructType\GetAttributeLookupValuesWithCodesResponse|\StructType\GetIndividualRefByAttributeCodeResponse|\StructType\GetIndividualRefByAttributeDescriptionResponse|\StructType\GetMemberRolesResponse|\StructType\GetUserByTokenResponse|\StructType\GetUserByUniqueIdResponse|\StructType\GetUserStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
