<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCountryFile ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCountryFile
 * @subpackage Arrays
 */
class ArrayOfCountryFile extends AbstractStructArrayBase
{
    /**
     * The CountryFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CountryFile[]
     */
    public $CountryFile;
    /**
     * Constructor method for ArrayOfCountryFile
     * @uses ArrayOfCountryFile::setCountryFile()
     * @param \StructType\CountryFile[] $countryFile
     */
    public function __construct(array $countryFile = array())
    {
        $this
            ->setCountryFile($countryFile);
    }
    /**
     * Get CountryFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CountryFile[]|null
     */
    public function getCountryFile()
    {
        return isset($this->CountryFile) ? $this->CountryFile : null;
    }
    /**
     * Set CountryFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CountryFile[] $countryFile
     * @return \ArrayType\ArrayOfCountryFile
     */
    public function setCountryFile(array $countryFile = array())
    {
        foreach ($countryFile as $arrayOfCountryFileCountryFileItem) {
            // validation for constraint: itemType
            if (!$arrayOfCountryFileCountryFileItem instanceof \StructType\CountryFile) {
                throw new \InvalidArgumentException(sprintf('The CountryFile property can only contain items of \StructType\CountryFile, "%s" given', is_object($arrayOfCountryFileCountryFileItem) ? get_class($arrayOfCountryFileCountryFileItem) : gettype($arrayOfCountryFileCountryFileItem)), __LINE__);
            }
        }
        if (is_null($countryFile) || (is_array($countryFile) && empty($countryFile))) {
            unset($this->CountryFile);
        } else {
            $this->CountryFile = $countryFile;
        }
        return $this;
    }
    /**
     * Add item to CountryFile value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryFile $item
     * @return \ArrayType\ArrayOfCountryFile
     */
    public function addToCountryFile(\StructType\CountryFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryFile) {
            throw new \InvalidArgumentException(sprintf('The CountryFile property can only contain items of \StructType\CountryFile, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CountryFile[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CountryFile|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CountryFile|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CountryFile|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CountryFile|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CountryFile|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CountryFile
     */
    public function getAttributeName()
    {
        return 'CountryFile';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCountryFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
