<?php

namespace App\Services\QBWC;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Connection ServiceType
 * @subpackage Services
 */
class Connection extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named connectionError
     * Meta information extracted from the WSDL
     * - documentation: This web method facilitates web service to handle connection error between QBWC and QB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\QBWC\ConnectionError $parameters
     * @return \App\Services\QBWC\ConnectionErrorResponse|bool
     */
    public function connectionError(\App\Services\QBWC\ConnectionError $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->connectionError($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\QBWC\ConnectionErrorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
