<?php

namespace App\Services\QBWC;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendRequestXML
     * Meta information extracted from the WSDL
     * - documentation: This web method facilitates web service to send request XML to QuickBooks via QBWebConnector
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\QBWC\SendRequestXML $parameters
     * @return \App\Services\QBWC\SendRequestXMLResponse|bool
     */
    public function sendRequestXML(\App\Services\QBWC\SendRequestXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->sendRequestXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\QBWC\SendRequestXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
