<?php

namespace App\Services\QBWC;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'serverVersion' => '\\App\\Services\\QBWC\\ServerVersion',
            'serverVersionResponse' => '\\App\\Services\\QBWC\\ServerVersionResponse',
            'clientVersion' => '\\App\\Services\\QBWC\\ClientVersion',
            'clientVersionResponse' => '\\App\\Services\\QBWC\\ClientVersionResponse',
            'authenticate' => '\\App\\Services\\QBWC\\Authenticate',
            'authenticateResponse' => '\\App\\Services\\QBWC\\AuthenticateResponse',
            'ArrayOfString' => '\\App\\Services\\QBWC\\ArrayOfString',
            'connectionError' => '\\App\\Services\\QBWC\\ConnectionError',
            'connectionErrorResponse' => '\\App\\Services\\QBWC\\ConnectionErrorResponse',
            'sendRequestXML' => '\\App\\Services\\QBWC\\SendRequestXML',
            'sendRequestXMLResponse' => '\\App\\Services\\QBWC\\SendRequestXMLResponse',
            'receiveResponseXML' => '\\App\\Services\\QBWC\\ReceiveResponseXML',
            'receiveResponseXMLResponse' => '\\App\\Services\\QBWC\\ReceiveResponseXMLResponse',
            'getLastError' => '\\App\\Services\\QBWC\\GetLastError',
            'getLastErrorResponse' => '\\App\\Services\\QBWC\\GetLastErrorResponse',
            'closeConnection' => '\\App\\Services\\QBWC\\CloseConnection',
            'closeConnectionResponse' => '\\App\\Services\\QBWC\\CloseConnectionResponse',
        );
    }
}
