<?php

namespace App\Services\QBWC;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for connectionError StructType
 * @subpackage Structs
 */
class ConnectionError extends AbstractStructBase
{
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ticket;
    /**
     * The hresult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hresult;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for connectionError
     * @uses ConnectionError::setTicket()
     * @uses ConnectionError::setHresult()
     * @uses ConnectionError::setMessage()
     * @param string $ticket
     * @param string $hresult
     * @param string $message
     */
    public function __construct($ticket = null, $hresult = null, $message = null)
    {
        $this
            ->setTicket($ticket)
            ->setHresult($hresult)
            ->setMessage($message);
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \App\Services\QBWC\ConnectionError
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get hresult value
     * @return string|null
     */
    public function getHresult()
    {
        return $this->hresult;
    }
    /**
     * Set hresult value
     * @param string $hresult
     * @return \App\Services\QBWC\ConnectionError
     */
    public function setHresult($hresult = null)
    {
        // validation for constraint: string
        if (!is_null($hresult) && !is_string($hresult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hresult, true), gettype($hresult)), __LINE__);
        }
        $this->hresult = $hresult;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \App\Services\QBWC\ConnectionError
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
