<?php

namespace App\Services\QBWC;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named authenticate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\QBWC\Authenticate $parameters
     * @return \App\Services\QBWC\AuthenticateResponse|bool
     */
    public function authenticate(\App\Services\QBWC\Authenticate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->authenticate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\QBWC\AuthenticateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
