<?php

namespace App\Services\QBWC;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Server ServiceType
 * @subpackage Services
 */
class Server extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named serverVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\QBWC\ServerVersion $parameters
     * @return \App\Services\QBWC\ServerVersionResponse|bool
     */
    public function serverVersion(\App\Services\QBWC\ServerVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->serverVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\QBWC\ServerVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
