<?php

namespace App\Services\QBWC;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Receive ServiceType
 * @subpackage Services
 */
class Receive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named receiveResponseXML
     * Meta information extracted from the WSDL
     * - documentation: This web method facilitates web service to receive response XML from QuickBooks via QBWebConnector
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\QBWC\ReceiveResponseXML $parameters
     * @return \App\Services\QBWC\ReceiveResponseXMLResponse|bool
     */
    public function receiveResponseXML(\App\Services\QBWC\ReceiveResponseXML $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->receiveResponseXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\QBWC\ReceiveResponseXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
