<?php

namespace App\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Server ServiceType
 * @subpackage Services
 */
class Server extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named serverVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\ServerVersion $parameters
     * @return \App\Services\ServerVersionResponse|bool
     */
    public function serverVersion(\App\Services\ServerVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->serverVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\ServerVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
