<?php

namespace App\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Connection ServiceType
 * @subpackage Services
 */
class Connection extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named connectionError
     * Meta information extracted from the WSDL
     * - documentation: This web method facilitates web service to handle connection error between QBWC and QB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\ConnectionError $parameters
     * @return \App\Services\ConnectionErrorResponse|bool
     */
    public function connectionError(\App\Services\ConnectionError $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->connectionError($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\ConnectionErrorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
