<?php

namespace App\Services;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for clientVersion StructType
 * @subpackage Structs
 */
class ClientVersion extends AbstractStructBase
{
    /**
     * The strVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strVersion;
    /**
     * Constructor method for clientVersion
     * @uses ClientVersion::setStrVersion()
     * @param string $strVersion
     */
    public function __construct($strVersion = null)
    {
        $this
            ->setStrVersion($strVersion);
    }
    /**
     * Get strVersion value
     * @return string|null
     */
    public function getStrVersion()
    {
        return $this->strVersion;
    }
    /**
     * Set strVersion value
     * @param string $strVersion
     * @return \App\Services\ClientVersion
     */
    public function setStrVersion($strVersion = null)
    {
        // validation for constraint: string
        if (!is_null($strVersion) && !is_string($strVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strVersion, true), gettype($strVersion)), __LINE__);
        }
        $this->strVersion = $strVersion;
        return $this;
    }
}
