<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.developer.intuit.com/QBWC/TroubleshootWebServiceFS/Service.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.developer.intuit.com/QBWC/TroubleshootWebServiceFS/Service.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\Services\ClassMap::get(),
);
/**
 * Samples for Server ServiceType
 */
$server = new \App\Services\Server($options);
/**
 * Sample call for serverVersion operation/method
 */
if ($server->serverVersion(new \App\Services\ServerVersion()) !== false) {
    print_r($server->getResult());
} else {
    print_r($server->getLastError());
}
/**
 * Samples for Client ServiceType
 */
$client = new \App\Services\Client($options);
/**
 * Sample call for clientVersion operation/method
 */
if ($client->clientVersion(new \App\Services\ClientVersion()) !== false) {
    print_r($client->getResult());
} else {
    print_r($client->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \App\Services\Authenticate($options);
/**
 * Sample call for authenticate operation/method
 */
if ($authenticate->authenticate(new \App\Services\Authenticate()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Connection ServiceType
 */
$connection = new \App\Services\Connection($options);
/**
 * Sample call for connectionError operation/method
 */
if ($connection->connectionError(new \App\Services\ConnectionError()) !== false) {
    print_r($connection->getResult());
} else {
    print_r($connection->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \App\Services\Send($options);
/**
 * Sample call for sendRequestXML operation/method
 */
if ($send->sendRequestXML(new \App\Services\SendRequestXML()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Receive ServiceType
 */
$receive = new \App\Services\Receive($options);
/**
 * Sample call for receiveResponseXML operation/method
 */
if ($receive->receiveResponseXML(new \App\Services\ReceiveResponseXML()) !== false) {
    print_r($receive->getResult());
} else {
    print_r($receive->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \App\Services\Get($options);
/**
 * Sample call for _getLastError operation/method
 */
if ($get->_getLastError(new \App\Services\GetLastError()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \App\Services\Close($options);
/**
 * Sample call for closeConnection operation/method
 */
if ($close->closeConnection(new \App\Services\CloseConnection()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
