<?php

namespace App\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Close ServiceType
 * @subpackage Services
 */
class Close extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named closeConnection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\CloseConnection $parameters
     * @return \App\Services\CloseConnectionResponse|bool
     */
    public function closeConnection(\App\Services\CloseConnection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->closeConnection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\CloseConnectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
