<?php

namespace App\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Client ServiceType
 * @subpackage Services
 */
class Client extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named clientVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\ClientVersion $parameters
     * @return \App\Services\ClientVersionResponse|bool
     */
    public function clientVersion(\App\Services\ClientVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->clientVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\ClientVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
