<?php

namespace App\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getLastError
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Services\GetLastError $parameters
     * @return \App\Services\GetLastErrorResponse|bool
     */
    public function _getLastError(\App\Services\GetLastError $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLastError($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Services\GetLastErrorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
