<?php

namespace App\Services;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'serverVersion' => '\\App\\Services\\ServerVersion',
            'serverVersionResponse' => '\\App\\Services\\ServerVersionResponse',
            'clientVersion' => '\\App\\Services\\ClientVersion',
            'clientVersionResponse' => '\\App\\Services\\ClientVersionResponse',
            'authenticate' => '\\App\\Services\\Authenticate',
            'authenticateResponse' => '\\App\\Services\\AuthenticateResponse',
            'ArrayOfString' => '\\App\\Services\\ArrayOfString',
            'connectionError' => '\\App\\Services\\ConnectionError',
            'connectionErrorResponse' => '\\App\\Services\\ConnectionErrorResponse',
            'sendRequestXML' => '\\App\\Services\\SendRequestXML',
            'sendRequestXMLResponse' => '\\App\\Services\\SendRequestXMLResponse',
            'receiveResponseXML' => '\\App\\Services\\ReceiveResponseXML',
            'receiveResponseXMLResponse' => '\\App\\Services\\ReceiveResponseXMLResponse',
            'getLastError' => '\\App\\Services\\GetLastError',
            'getLastErrorResponse' => '\\App\\Services\\GetLastErrorResponse',
            'closeConnection' => '\\App\\Services\\CloseConnection',
            'closeConnectionResponse' => '\\App\\Services\\CloseConnectionResponse',
        );
    }
}
