<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoverCfgInterativo StructType
 * Meta information extracted from the WSDL
 * - type: tns:RemoverCfgInterativo
 * @subpackage Structs
 */
class RemoverCfgInterativo extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdTerminal;
    /**
     * The IdSequencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdSequencia;
    /**
     * The IdConfig
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdConfig;
    /**
     * Constructor method for RemoverCfgInterativo
     * @uses RemoverCfgInterativo::setUsuario()
     * @uses RemoverCfgInterativo::setSenha()
     * @uses RemoverCfgInterativo::setIdTerminal()
     * @uses RemoverCfgInterativo::setIdSequencia()
     * @uses RemoverCfgInterativo::setIdConfig()
     * @param string $usuario
     * @param string $senha
     * @param int $idTerminal
     * @param int $idSequencia
     * @param int $idConfig
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $idSequencia = null, $idConfig = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setIdSequencia($idSequencia)
            ->setIdConfig($idConfig);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\RemoverCfgInterativo
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\RemoverCfgInterativo
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return int|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param int $idTerminal
     * @return \StructType\RemoverCfgInterativo
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: int
        if (!is_null($idTerminal) && !(is_int($idTerminal) || ctype_digit($idTerminal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get IdSequencia value
     * @return int|null
     */
    public function getIdSequencia()
    {
        return $this->IdSequencia;
    }
    /**
     * Set IdSequencia value
     * @param int $idSequencia
     * @return \StructType\RemoverCfgInterativo
     */
    public function setIdSequencia($idSequencia = null)
    {
        // validation for constraint: int
        if (!is_null($idSequencia) && !(is_int($idSequencia) || ctype_digit($idSequencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idSequencia, true), gettype($idSequencia)), __LINE__);
        }
        $this->IdSequencia = $idSequencia;
        return $this;
    }
    /**
     * Get IdConfig value
     * @return int|null
     */
    public function getIdConfig()
    {
        return $this->IdConfig;
    }
    /**
     * Set IdConfig value
     * @param int $idConfig
     * @return \StructType\RemoverCfgInterativo
     */
    public function setIdConfig($idConfig = null)
    {
        // validation for constraint: int
        if (!is_null($idConfig) && !(is_int($idConfig) || ctype_digit($idConfig))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idConfig, true), gettype($idConfig)), __LINE__);
        }
        $this->IdConfig = $idConfig;
        return $this;
    }
}
