<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdenarAlvosAssociados StructType
 * Meta information extracted from the WSDL
 * - type: tns:OrdenarAlvosAssociados
 * @subpackage Structs
 */
class OrdenarAlvosAssociados extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdVeiculo;
    /**
     * The Alvos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Alvos;
    /**
     * Constructor method for OrdenarAlvosAssociados
     * @uses OrdenarAlvosAssociados::setUsuario()
     * @uses OrdenarAlvosAssociados::setSenha()
     * @uses OrdenarAlvosAssociados::setIdVeiculo()
     * @uses OrdenarAlvosAssociados::setAlvos()
     * @param string $usuario
     * @param string $senha
     * @param int $idVeiculo
     * @param string $alvos
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, $alvos = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setAlvos($alvos);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\OrdenarAlvosAssociados
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\OrdenarAlvosAssociados
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->IdVeiculo;
    }
    /**
     * Set IdVeiculo value
     * @param int $idVeiculo
     * @return \StructType\OrdenarAlvosAssociados
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->IdVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get Alvos value
     * @return string|null
     */
    public function getAlvos()
    {
        return $this->Alvos;
    }
    /**
     * Set Alvos value
     * @param string $alvos
     * @return \StructType\OrdenarAlvosAssociados
     */
    public function setAlvos($alvos = null)
    {
        // validation for constraint: string
        if (!is_null($alvos) && !is_string($alvos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alvos, true), gettype($alvos)), __LINE__);
        }
        $this->Alvos = $alvos;
        return $this;
    }
}
