<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObtemStatusComando StructType
 * Meta information extracted from the WSDL
 * - type: tns:ObtemStatusComando
 * @subpackage Structs
 */
class ObtemStatusComando extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idComando
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idComando;
    /**
     * Constructor method for ObtemStatusComando
     * @uses ObtemStatusComando::setUsuario()
     * @uses ObtemStatusComando::setSenha()
     * @uses ObtemStatusComando::setIdComando()
     * @param string $usuario
     * @param string $senha
     * @param int $idComando
     */
    public function __construct($usuario = null, $senha = null, $idComando = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdComando($idComando);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ObtemStatusComando
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ObtemStatusComando
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idComando value
     * @return int|null
     */
    public function getIdComando()
    {
        return $this->idComando;
    }
    /**
     * Set idComando value
     * @param int $idComando
     * @return \StructType\ObtemStatusComando
     */
    public function setIdComando($idComando = null)
    {
        // validation for constraint: int
        if (!is_null($idComando) && !(is_int($idComando) || ctype_digit($idComando))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idComando, true), gettype($idComando)), __LINE__);
        }
        $this->idComando = $idComando;
        return $this;
    }
}
