<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObtemEventosIscas StructType
 * Meta information extracted from the WSDL
 * - type: tns:ObtemEventosIscas
 * @subpackage Structs
 */
class ObtemEventosIscas extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The UltimoSequencial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimoSequencial;
    /**
     * Constructor method for ObtemEventosIscas
     * @uses ObtemEventosIscas::setUsuario()
     * @uses ObtemEventosIscas::setSenha()
     * @uses ObtemEventosIscas::setUltimoSequencial()
     * @param string $usuario
     * @param string $senha
     * @param int $ultimoSequencial
     */
    public function __construct($usuario = null, $senha = null, $ultimoSequencial = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setUltimoSequencial($ultimoSequencial);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ObtemEventosIscas
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ObtemEventosIscas
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get UltimoSequencial value
     * @return int|null
     */
    public function getUltimoSequencial()
    {
        return $this->UltimoSequencial;
    }
    /**
     * Set UltimoSequencial value
     * @param int $ultimoSequencial
     * @return \StructType\ObtemEventosIscas
     */
    public function setUltimoSequencial($ultimoSequencial = null)
    {
        // validation for constraint: int
        if (!is_null($ultimoSequencial) && !(is_int($ultimoSequencial) || ctype_digit($ultimoSequencial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimoSequencial, true), gettype($ultimoSequencial)), __LINE__);
        }
        $this->UltimoSequencial = $ultimoSequencial;
        return $this;
    }
}
