<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MudarGrupoDaRota StructType
 * Meta information extracted from the WSDL
 * - type: tns:MudarGrupoDaRota
 * @subpackage Structs
 */
class MudarGrupoDaRota extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The GrupoAntigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GrupoAntigo;
    /**
     * The NomeDaRota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NomeDaRota;
    /**
     * The GrupoNovo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GrupoNovo;
    /**
     * Constructor method for MudarGrupoDaRota
     * @uses MudarGrupoDaRota::setUsuario()
     * @uses MudarGrupoDaRota::setSenha()
     * @uses MudarGrupoDaRota::setGrupoAntigo()
     * @uses MudarGrupoDaRota::setNomeDaRota()
     * @uses MudarGrupoDaRota::setGrupoNovo()
     * @param string $usuario
     * @param string $senha
     * @param string $grupoAntigo
     * @param string $nomeDaRota
     * @param string $grupoNovo
     */
    public function __construct($usuario = null, $senha = null, $grupoAntigo = null, $nomeDaRota = null, $grupoNovo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setGrupoAntigo($grupoAntigo)
            ->setNomeDaRota($nomeDaRota)
            ->setGrupoNovo($grupoNovo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\MudarGrupoDaRota
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\MudarGrupoDaRota
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get GrupoAntigo value
     * @return string|null
     */
    public function getGrupoAntigo()
    {
        return $this->GrupoAntigo;
    }
    /**
     * Set GrupoAntigo value
     * @param string $grupoAntigo
     * @return \StructType\MudarGrupoDaRota
     */
    public function setGrupoAntigo($grupoAntigo = null)
    {
        // validation for constraint: string
        if (!is_null($grupoAntigo) && !is_string($grupoAntigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupoAntigo, true), gettype($grupoAntigo)), __LINE__);
        }
        $this->GrupoAntigo = $grupoAntigo;
        return $this;
    }
    /**
     * Get NomeDaRota value
     * @return string|null
     */
    public function getNomeDaRota()
    {
        return $this->NomeDaRota;
    }
    /**
     * Set NomeDaRota value
     * @param string $nomeDaRota
     * @return \StructType\MudarGrupoDaRota
     */
    public function setNomeDaRota($nomeDaRota = null)
    {
        // validation for constraint: string
        if (!is_null($nomeDaRota) && !is_string($nomeDaRota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeDaRota, true), gettype($nomeDaRota)), __LINE__);
        }
        $this->NomeDaRota = $nomeDaRota;
        return $this;
    }
    /**
     * Get GrupoNovo value
     * @return string|null
     */
    public function getGrupoNovo()
    {
        return $this->GrupoNovo;
    }
    /**
     * Set GrupoNovo value
     * @param string $grupoNovo
     * @return \StructType\MudarGrupoDaRota
     */
    public function setGrupoNovo($grupoNovo = null)
    {
        // validation for constraint: string
        if (!is_null($grupoNovo) && !is_string($grupoNovo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupoNovo, true), gettype($grupoNovo)), __LINE__);
        }
        $this->GrupoNovo = $grupoNovo;
        return $this;
    }
}
