<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListarSensoresDeAlarme StructType
 * Meta information extracted from the WSDL
 * - type: tns:ListarSensoresDeAlarme
 * @subpackage Structs
 */
class ListarSensoresDeAlarme extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tipo;
    /**
     * Constructor method for ListarSensoresDeAlarme
     * @uses ListarSensoresDeAlarme::setUsuario()
     * @uses ListarSensoresDeAlarme::setSenha()
     * @uses ListarSensoresDeAlarme::setTipo()
     * @param string $usuario
     * @param string $senha
     * @param int $tipo
     */
    public function __construct($usuario = null, $senha = null, $tipo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setTipo($tipo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ListarSensoresDeAlarme
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ListarSensoresDeAlarme
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Tipo value
     * @return int|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param int $tipo
     * @return \StructType\ListarSensoresDeAlarme
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: int
        if (!is_null($tipo) && !(is_int($tipo) || ctype_digit($tipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
}
