<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcluirMotivo StructType
 * Meta information extracted from the WSDL
 * - type: tns:ExcluirMotivo
 * @subpackage Structs
 */
class ExcluirMotivo extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tipo;
    /**
     * The Motivo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Motivo;
    /**
     * Constructor method for ExcluirMotivo
     * @uses ExcluirMotivo::setUsuario()
     * @uses ExcluirMotivo::setSenha()
     * @uses ExcluirMotivo::setTipo()
     * @uses ExcluirMotivo::setMotivo()
     * @param string $usuario
     * @param string $senha
     * @param int $tipo
     * @param string $motivo
     */
    public function __construct($usuario = null, $senha = null, $tipo = null, $motivo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setTipo($tipo)
            ->setMotivo($motivo);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\ExcluirMotivo
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\ExcluirMotivo
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Tipo value
     * @return int|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param int $tipo
     * @return \StructType\ExcluirMotivo
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: int
        if (!is_null($tipo) && !(is_int($tipo) || ctype_digit($tipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get Motivo value
     * @return string|null
     */
    public function getMotivo()
    {
        return $this->Motivo;
    }
    /**
     * Set Motivo value
     * @param string $motivo
     * @return \StructType\ExcluirMotivo
     */
    public function setMotivo($motivo = null)
    {
        // validation for constraint: string
        if (!is_null($motivo) && !is_string($motivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivo, true), gettype($motivo)), __LINE__);
        }
        $this->Motivo = $motivo;
        return $this;
    }
}
