<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnviarConfigOmniTelemetria StructType
 * Meta information extracted from the WSDL
 * - type: tns:EnviarConfigOmniTelemetria
 * @subpackage Structs
 */
class EnviarConfigOmniTelemetria extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdTerminal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IdTerminal;
    /**
     * The Comando
     * @var int
     */
    public $Comando;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Valor;
    /**
     * Constructor method for EnviarConfigOmniTelemetria
     * @uses EnviarConfigOmniTelemetria::setUsuario()
     * @uses EnviarConfigOmniTelemetria::setSenha()
     * @uses EnviarConfigOmniTelemetria::setIdTerminal()
     * @uses EnviarConfigOmniTelemetria::setComando()
     * @uses EnviarConfigOmniTelemetria::setValor()
     * @param string $usuario
     * @param string $senha
     * @param string $idTerminal
     * @param int $comando
     * @param string $valor
     */
    public function __construct($usuario = null, $senha = null, $idTerminal = null, $comando = null, $valor = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdTerminal($idTerminal)
            ->setComando($comando)
            ->setValor($valor);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\EnviarConfigOmniTelemetria
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\EnviarConfigOmniTelemetria
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdTerminal value
     * @return string|null
     */
    public function getIdTerminal()
    {
        return $this->IdTerminal;
    }
    /**
     * Set IdTerminal value
     * @param string $idTerminal
     * @return \StructType\EnviarConfigOmniTelemetria
     */
    public function setIdTerminal($idTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($idTerminal) && !is_string($idTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idTerminal, true), gettype($idTerminal)), __LINE__);
        }
        $this->IdTerminal = $idTerminal;
        return $this;
    }
    /**
     * Get Comando value
     * @return int|null
     */
    public function getComando()
    {
        return $this->Comando;
    }
    /**
     * Set Comando value
     * @param int $comando
     * @return \StructType\EnviarConfigOmniTelemetria
     */
    public function setComando($comando = null)
    {
        // validation for constraint: int
        if (!is_null($comando) && !(is_int($comando) || ctype_digit($comando))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($comando, true), gettype($comando)), __LINE__);
        }
        $this->Comando = $comando;
        return $this;
    }
    /**
     * Get Valor value
     * @return string|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param string $valor
     * @return \StructType\EnviarConfigOmniTelemetria
     */
    public function setValor($valor = null)
    {
        // validation for constraint: string
        if (!is_null($valor) && !is_string($valor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
}
