<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditarVariavelPersonalizada StructType
 * Meta information extracted from the WSDL
 * - type: tns:EditarVariavelPersonalizada
 * @subpackage Structs
 */
class EditarVariavelPersonalizada extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Identificador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Identificador;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * The Disponibilidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Disponibilidade;
    /**
     * Constructor method for EditarVariavelPersonalizada
     * @uses EditarVariavelPersonalizada::setUsuario()
     * @uses EditarVariavelPersonalizada::setSenha()
     * @uses EditarVariavelPersonalizada::setIdentificador()
     * @uses EditarVariavelPersonalizada::setDescricao()
     * @uses EditarVariavelPersonalizada::setDisponibilidade()
     * @param string $usuario
     * @param string $senha
     * @param string $identificador
     * @param string $descricao
     * @param int $disponibilidade
     */
    public function __construct($usuario = null, $senha = null, $identificador = null, $descricao = null, $disponibilidade = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdentificador($identificador)
            ->setDescricao($descricao)
            ->setDisponibilidade($disponibilidade);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\EditarVariavelPersonalizada
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\EditarVariavelPersonalizada
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Identificador value
     * @return string|null
     */
    public function getIdentificador()
    {
        return $this->Identificador;
    }
    /**
     * Set Identificador value
     * @param string $identificador
     * @return \StructType\EditarVariavelPersonalizada
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: string
        if (!is_null($identificador) && !is_string($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificador, true), gettype($identificador)), __LINE__);
        }
        $this->Identificador = $identificador;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\EditarVariavelPersonalizada
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
    /**
     * Get Disponibilidade value
     * @return int|null
     */
    public function getDisponibilidade()
    {
        return $this->Disponibilidade;
    }
    /**
     * Set Disponibilidade value
     * @param int $disponibilidade
     * @return \StructType\EditarVariavelPersonalizada
     */
    public function setDisponibilidade($disponibilidade = null)
    {
        // validation for constraint: int
        if (!is_null($disponibilidade) && !(is_int($disponibilidade) || ctype_digit($disponibilidade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($disponibilidade, true), gettype($disponibilidade)), __LINE__);
        }
        $this->Disponibilidade = $disponibilidade;
        return $this;
    }
}
