<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditarTextoTerminal StructType
 * Meta information extracted from the WSDL
 * - type: tns:EditarTextoTerminal
 * @subpackage Structs
 */
class EditarTextoTerminal extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Sequencial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sequencial;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tipo;
    /**
     * The Texto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Texto;
    /**
     * Constructor method for EditarTextoTerminal
     * @uses EditarTextoTerminal::setUsuario()
     * @uses EditarTextoTerminal::setSenha()
     * @uses EditarTextoTerminal::setSequencial()
     * @uses EditarTextoTerminal::setTipo()
     * @uses EditarTextoTerminal::setTexto()
     * @param string $usuario
     * @param string $senha
     * @param int $sequencial
     * @param int $tipo
     * @param string $texto
     */
    public function __construct($usuario = null, $senha = null, $sequencial = null, $tipo = null, $texto = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setSequencial($sequencial)
            ->setTipo($tipo)
            ->setTexto($texto);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\EditarTextoTerminal
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\EditarTextoTerminal
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Sequencial value
     * @return int|null
     */
    public function getSequencial()
    {
        return $this->Sequencial;
    }
    /**
     * Set Sequencial value
     * @param int $sequencial
     * @return \StructType\EditarTextoTerminal
     */
    public function setSequencial($sequencial = null)
    {
        // validation for constraint: int
        if (!is_null($sequencial) && !(is_int($sequencial) || ctype_digit($sequencial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequencial, true), gettype($sequencial)), __LINE__);
        }
        $this->Sequencial = $sequencial;
        return $this;
    }
    /**
     * Get Tipo value
     * @return int|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param int $tipo
     * @return \StructType\EditarTextoTerminal
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: int
        if (!is_null($tipo) && !(is_int($tipo) || ctype_digit($tipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get Texto value
     * @return string|null
     */
    public function getTexto()
    {
        return $this->Texto;
    }
    /**
     * Set Texto value
     * @param string $texto
     * @return \StructType\EditarTextoTerminal
     */
    public function setTexto($texto = null)
    {
        // validation for constraint: string
        if (!is_null($texto) && !is_string($texto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($texto, true), gettype($texto)), __LINE__);
        }
        $this->Texto = $texto;
        return $this;
    }
}
