<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DesativarConfiguracoesTransicao StructType
 * Meta information extracted from the WSDL
 * - type: tns:DesativarConfiguracoesTransicao
 * @subpackage Structs
 */
class DesativarConfiguracoesTransicao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IDSequencia
     * @var int
     */
    public $IDSequencia;
    /**
     * Constructor method for DesativarConfiguracoesTransicao
     * @uses DesativarConfiguracoesTransicao::setUsuario()
     * @uses DesativarConfiguracoesTransicao::setSenha()
     * @uses DesativarConfiguracoesTransicao::setIDSequencia()
     * @param string $usuario
     * @param string $senha
     * @param int $iDSequencia
     */
    public function __construct($usuario = null, $senha = null, $iDSequencia = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIDSequencia($iDSequencia);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\DesativarConfiguracoesTransicao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\DesativarConfiguracoesTransicao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IDSequencia value
     * @return int|null
     */
    public function getIDSequencia()
    {
        return $this->IDSequencia;
    }
    /**
     * Set IDSequencia value
     * @param int $iDSequencia
     * @return \StructType\DesativarConfiguracoesTransicao
     */
    public function setIDSequencia($iDSequencia = null)
    {
        // validation for constraint: int
        if (!is_null($iDSequencia) && !(is_int($iDSequencia) || ctype_digit($iDSequencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDSequencia, true), gettype($iDSequencia)), __LINE__);
        }
        $this->IDSequencia = $iDSequencia;
        return $this;
    }
}
