<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CriarRegra StructType
 * Meta information extracted from the WSDL
 * - type: tns:CriarRegra
 * @subpackage Structs
 */
class CriarRegra extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdFuncProg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdFuncProg;
    /**
     * The Nome_Regra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nome_Regra;
    /**
     * The CriterioExecucao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CriterioExecucao;
    /**
     * The TempMaxExecucao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TempMaxExecucao;
    /**
     * The NumMaxExecucao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumMaxExecucao;
    /**
     * Constructor method for CriarRegra
     * @uses CriarRegra::setUsuario()
     * @uses CriarRegra::setSenha()
     * @uses CriarRegra::setIdFuncProg()
     * @uses CriarRegra::setNome_Regra()
     * @uses CriarRegra::setCriterioExecucao()
     * @uses CriarRegra::setTempMaxExecucao()
     * @uses CriarRegra::setNumMaxExecucao()
     * @param string $usuario
     * @param string $senha
     * @param int $idFuncProg
     * @param string $nome_Regra
     * @param int $criterioExecucao
     * @param int $tempMaxExecucao
     * @param int $numMaxExecucao
     */
    public function __construct($usuario = null, $senha = null, $idFuncProg = null, $nome_Regra = null, $criterioExecucao = null, $tempMaxExecucao = null, $numMaxExecucao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdFuncProg($idFuncProg)
            ->setNome_Regra($nome_Regra)
            ->setCriterioExecucao($criterioExecucao)
            ->setTempMaxExecucao($tempMaxExecucao)
            ->setNumMaxExecucao($numMaxExecucao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\CriarRegra
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\CriarRegra
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdFuncProg value
     * @return int|null
     */
    public function getIdFuncProg()
    {
        return $this->IdFuncProg;
    }
    /**
     * Set IdFuncProg value
     * @param int $idFuncProg
     * @return \StructType\CriarRegra
     */
    public function setIdFuncProg($idFuncProg = null)
    {
        // validation for constraint: int
        if (!is_null($idFuncProg) && !(is_int($idFuncProg) || ctype_digit($idFuncProg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idFuncProg, true), gettype($idFuncProg)), __LINE__);
        }
        $this->IdFuncProg = $idFuncProg;
        return $this;
    }
    /**
     * Get Nome_Regra value
     * @return string|null
     */
    public function getNome_Regra()
    {
        return $this->Nome_Regra;
    }
    /**
     * Set Nome_Regra value
     * @param string $nome_Regra
     * @return \StructType\CriarRegra
     */
    public function setNome_Regra($nome_Regra = null)
    {
        // validation for constraint: string
        if (!is_null($nome_Regra) && !is_string($nome_Regra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome_Regra, true), gettype($nome_Regra)), __LINE__);
        }
        $this->Nome_Regra = $nome_Regra;
        return $this;
    }
    /**
     * Get CriterioExecucao value
     * @return int|null
     */
    public function getCriterioExecucao()
    {
        return $this->CriterioExecucao;
    }
    /**
     * Set CriterioExecucao value
     * @param int $criterioExecucao
     * @return \StructType\CriarRegra
     */
    public function setCriterioExecucao($criterioExecucao = null)
    {
        // validation for constraint: int
        if (!is_null($criterioExecucao) && !(is_int($criterioExecucao) || ctype_digit($criterioExecucao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($criterioExecucao, true), gettype($criterioExecucao)), __LINE__);
        }
        $this->CriterioExecucao = $criterioExecucao;
        return $this;
    }
    /**
     * Get TempMaxExecucao value
     * @return int|null
     */
    public function getTempMaxExecucao()
    {
        return $this->TempMaxExecucao;
    }
    /**
     * Set TempMaxExecucao value
     * @param int $tempMaxExecucao
     * @return \StructType\CriarRegra
     */
    public function setTempMaxExecucao($tempMaxExecucao = null)
    {
        // validation for constraint: int
        if (!is_null($tempMaxExecucao) && !(is_int($tempMaxExecucao) || ctype_digit($tempMaxExecucao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tempMaxExecucao, true), gettype($tempMaxExecucao)), __LINE__);
        }
        $this->TempMaxExecucao = $tempMaxExecucao;
        return $this;
    }
    /**
     * Get NumMaxExecucao value
     * @return int|null
     */
    public function getNumMaxExecucao()
    {
        return $this->NumMaxExecucao;
    }
    /**
     * Set NumMaxExecucao value
     * @param int $numMaxExecucao
     * @return \StructType\CriarRegra
     */
    public function setNumMaxExecucao($numMaxExecucao = null)
    {
        // validation for constraint: int
        if (!is_null($numMaxExecucao) && !(is_int($numMaxExecucao) || ctype_digit($numMaxExecucao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMaxExecucao, true), gettype($numMaxExecucao)), __LINE__);
        }
        $this->NumMaxExecucao = $numMaxExecucao;
        return $this;
    }
}
