<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CriarPerfilRota StructType
 * Meta information extracted from the WSDL
 * - type: tns:CriarPerfilRota
 * @subpackage Structs
 */
class CriarPerfilRota extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nome;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tipo;
    /**
     * The Tolerancia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tolerancia;
    /**
     * The IdFuncProgEntrada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdFuncProgEntrada;
    /**
     * The IdFuncProgSaida
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdFuncProgSaida;
    /**
     * Constructor method for CriarPerfilRota
     * @uses CriarPerfilRota::setUsuario()
     * @uses CriarPerfilRota::setSenha()
     * @uses CriarPerfilRota::setNome()
     * @uses CriarPerfilRota::setTipo()
     * @uses CriarPerfilRota::setTolerancia()
     * @uses CriarPerfilRota::setIdFuncProgEntrada()
     * @uses CriarPerfilRota::setIdFuncProgSaida()
     * @param string $usuario
     * @param string $senha
     * @param string $nome
     * @param int $tipo
     * @param int $tolerancia
     * @param int $idFuncProgEntrada
     * @param int $idFuncProgSaida
     */
    public function __construct($usuario = null, $senha = null, $nome = null, $tipo = null, $tolerancia = null, $idFuncProgEntrada = null, $idFuncProgSaida = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setNome($nome)
            ->setTipo($tipo)
            ->setTolerancia($tolerancia)
            ->setIdFuncProgEntrada($idFuncProgEntrada)
            ->setIdFuncProgSaida($idFuncProgSaida);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\CriarPerfilRota
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\CriarPerfilRota
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->Nome;
    }
    /**
     * Set Nome value
     * @param string $nome
     * @return \StructType\CriarPerfilRota
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->Nome = $nome;
        return $this;
    }
    /**
     * Get Tipo value
     * @return int|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param int $tipo
     * @return \StructType\CriarPerfilRota
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: int
        if (!is_null($tipo) && !(is_int($tipo) || ctype_digit($tipo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get Tolerancia value
     * @return int|null
     */
    public function getTolerancia()
    {
        return $this->Tolerancia;
    }
    /**
     * Set Tolerancia value
     * @param int $tolerancia
     * @return \StructType\CriarPerfilRota
     */
    public function setTolerancia($tolerancia = null)
    {
        // validation for constraint: int
        if (!is_null($tolerancia) && !(is_int($tolerancia) || ctype_digit($tolerancia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tolerancia, true), gettype($tolerancia)), __LINE__);
        }
        $this->Tolerancia = $tolerancia;
        return $this;
    }
    /**
     * Get IdFuncProgEntrada value
     * @return int|null
     */
    public function getIdFuncProgEntrada()
    {
        return $this->IdFuncProgEntrada;
    }
    /**
     * Set IdFuncProgEntrada value
     * @param int $idFuncProgEntrada
     * @return \StructType\CriarPerfilRota
     */
    public function setIdFuncProgEntrada($idFuncProgEntrada = null)
    {
        // validation for constraint: int
        if (!is_null($idFuncProgEntrada) && !(is_int($idFuncProgEntrada) || ctype_digit($idFuncProgEntrada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idFuncProgEntrada, true), gettype($idFuncProgEntrada)), __LINE__);
        }
        $this->IdFuncProgEntrada = $idFuncProgEntrada;
        return $this;
    }
    /**
     * Get IdFuncProgSaida value
     * @return int|null
     */
    public function getIdFuncProgSaida()
    {
        return $this->IdFuncProgSaida;
    }
    /**
     * Set IdFuncProgSaida value
     * @param int $idFuncProgSaida
     * @return \StructType\CriarPerfilRota
     */
    public function setIdFuncProgSaida($idFuncProgSaida = null)
    {
        // validation for constraint: int
        if (!is_null($idFuncProgSaida) && !(is_int($idFuncProgSaida) || ctype_digit($idFuncProgSaida))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idFuncProgSaida, true), gettype($idFuncProgSaida)), __LINE__);
        }
        $this->IdFuncProgSaida = $idFuncProgSaida;
        return $this;
    }
}
