<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CriarModTransicao StructType
 * Meta information extracted from the WSDL
 * - type: tns:CriarModTransicao
 * @subpackage Structs
 */
class CriarModTransicao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * The IdModTransOrigem
     * @var int
     */
    public $IdModTransOrigem;
    /**
     * The RodarFPsEmModoDesativado
     * @var int
     */
    public $RodarFPsEmModoDesativado;
    /**
     * Constructor method for CriarModTransicao
     * @uses CriarModTransicao::setUsuario()
     * @uses CriarModTransicao::setSenha()
     * @uses CriarModTransicao::setDescricao()
     * @uses CriarModTransicao::setIdModTransOrigem()
     * @uses CriarModTransicao::setRodarFPsEmModoDesativado()
     * @param string $usuario
     * @param string $senha
     * @param string $descricao
     * @param int $idModTransOrigem
     * @param int $rodarFPsEmModoDesativado
     */
    public function __construct($usuario = null, $senha = null, $descricao = null, $idModTransOrigem = null, $rodarFPsEmModoDesativado = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setDescricao($descricao)
            ->setIdModTransOrigem($idModTransOrigem)
            ->setRodarFPsEmModoDesativado($rodarFPsEmModoDesativado);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\CriarModTransicao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\CriarModTransicao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\CriarModTransicao
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
    /**
     * Get IdModTransOrigem value
     * @return int|null
     */
    public function getIdModTransOrigem()
    {
        return $this->IdModTransOrigem;
    }
    /**
     * Set IdModTransOrigem value
     * @param int $idModTransOrigem
     * @return \StructType\CriarModTransicao
     */
    public function setIdModTransOrigem($idModTransOrigem = null)
    {
        // validation for constraint: int
        if (!is_null($idModTransOrigem) && !(is_int($idModTransOrigem) || ctype_digit($idModTransOrigem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idModTransOrigem, true), gettype($idModTransOrigem)), __LINE__);
        }
        $this->IdModTransOrigem = $idModTransOrigem;
        return $this;
    }
    /**
     * Get RodarFPsEmModoDesativado value
     * @return int|null
     */
    public function getRodarFPsEmModoDesativado()
    {
        return $this->RodarFPsEmModoDesativado;
    }
    /**
     * Set RodarFPsEmModoDesativado value
     * @param int $rodarFPsEmModoDesativado
     * @return \StructType\CriarModTransicao
     */
    public function setRodarFPsEmModoDesativado($rodarFPsEmModoDesativado = null)
    {
        // validation for constraint: int
        if (!is_null($rodarFPsEmModoDesativado) && !(is_int($rodarFPsEmModoDesativado) || ctype_digit($rodarFPsEmModoDesativado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rodarFPsEmModoDesativado, true), gettype($rodarFPsEmModoDesativado)), __LINE__);
        }
        $this->RodarFPsEmModoDesativado = $rodarFPsEmModoDesativado;
        return $this;
    }
}
