<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuscarRotasLikeNome StructType
 * Meta information extracted from the WSDL
 * - type: tns:BuscarRotasLikeNome
 * @subpackage Structs
 */
class BuscarRotasLikeNome extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IdGrupoSaver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdGrupoSaver;
    /**
     * The NomeRota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NomeRota;
    /**
     * Constructor method for BuscarRotasLikeNome
     * @uses BuscarRotasLikeNome::setUsuario()
     * @uses BuscarRotasLikeNome::setSenha()
     * @uses BuscarRotasLikeNome::setIdGrupoSaver()
     * @uses BuscarRotasLikeNome::setNomeRota()
     * @param string $usuario
     * @param string $senha
     * @param int $idGrupoSaver
     * @param string $nomeRota
     */
    public function __construct($usuario = null, $senha = null, $idGrupoSaver = null, $nomeRota = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdGrupoSaver($idGrupoSaver)
            ->setNomeRota($nomeRota);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\BuscarRotasLikeNome
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\BuscarRotasLikeNome
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IdGrupoSaver value
     * @return int|null
     */
    public function getIdGrupoSaver()
    {
        return $this->IdGrupoSaver;
    }
    /**
     * Set IdGrupoSaver value
     * @param int $idGrupoSaver
     * @return \StructType\BuscarRotasLikeNome
     */
    public function setIdGrupoSaver($idGrupoSaver = null)
    {
        // validation for constraint: int
        if (!is_null($idGrupoSaver) && !(is_int($idGrupoSaver) || ctype_digit($idGrupoSaver))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idGrupoSaver, true), gettype($idGrupoSaver)), __LINE__);
        }
        $this->IdGrupoSaver = $idGrupoSaver;
        return $this;
    }
    /**
     * Get NomeRota value
     * @return string|null
     */
    public function getNomeRota()
    {
        return $this->NomeRota;
    }
    /**
     * Set NomeRota value
     * @param string $nomeRota
     * @return \StructType\BuscarRotasLikeNome
     */
    public function setNomeRota($nomeRota = null)
    {
        // validation for constraint: string
        if (!is_null($nomeRota) && !is_string($nomeRota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeRota, true), gettype($nomeRota)), __LINE__);
        }
        $this->NomeRota = $nomeRota;
        return $this;
    }
}
