<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AtualizarPerfilCfg StructType
 * Meta information extracted from the WSDL
 * - type: tns:AtualizarPerfilCfg
 * @subpackage Structs
 */
class AtualizarPerfilCfg extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The idPerfil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idPerfil;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nome;
    /**
     * Constructor method for AtualizarPerfilCfg
     * @uses AtualizarPerfilCfg::setUsuario()
     * @uses AtualizarPerfilCfg::setSenha()
     * @uses AtualizarPerfilCfg::setIdPerfil()
     * @uses AtualizarPerfilCfg::setNome()
     * @param string $usuario
     * @param string $senha
     * @param int $idPerfil
     * @param string $nome
     */
    public function __construct($usuario = null, $senha = null, $idPerfil = null, $nome = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdPerfil($idPerfil)
            ->setNome($nome);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\AtualizarPerfilCfg
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\AtualizarPerfilCfg
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get idPerfil value
     * @return int|null
     */
    public function getIdPerfil()
    {
        return $this->idPerfil;
    }
    /**
     * Set idPerfil value
     * @param int $idPerfil
     * @return \StructType\AtualizarPerfilCfg
     */
    public function setIdPerfil($idPerfil = null)
    {
        // validation for constraint: int
        if (!is_null($idPerfil) && !(is_int($idPerfil) || ctype_digit($idPerfil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPerfil, true), gettype($idPerfil)), __LINE__);
        }
        $this->idPerfil = $idPerfil;
        return $this;
    }
    /**
     * Get Nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->Nome;
    }
    /**
     * Set Nome value
     * @param string $nome
     * @return \StructType\AtualizarPerfilCfg
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->Nome = $nome;
        return $this;
    }
}
