<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AtualizarConfiguracoesTransicao StructType
 * Meta information extracted from the WSDL
 * - type: tns:AtualizarConfiguracoesTransicao
 * @subpackage Structs
 */
class AtualizarConfiguracoesTransicao extends AbstractStructBase
{
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Usuario;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * The IDSequencia
     * @var int
     */
    public $IDSequencia;
    /**
     * The IdModTransicao
     * @var int
     */
    public $IdModTransicao;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Descricao;
    /**
     * Constructor method for AtualizarConfiguracoesTransicao
     * @uses AtualizarConfiguracoesTransicao::setUsuario()
     * @uses AtualizarConfiguracoesTransicao::setSenha()
     * @uses AtualizarConfiguracoesTransicao::setIDSequencia()
     * @uses AtualizarConfiguracoesTransicao::setIdModTransicao()
     * @uses AtualizarConfiguracoesTransicao::setDescricao()
     * @param string $usuario
     * @param string $senha
     * @param int $iDSequencia
     * @param int $idModTransicao
     * @param string $descricao
     */
    public function __construct($usuario = null, $senha = null, $iDSequencia = null, $idModTransicao = null, $descricao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIDSequencia($iDSequencia)
            ->setIdModTransicao($idModTransicao)
            ->setDescricao($descricao);
    }
    /**
     * Get Usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->Usuario;
    }
    /**
     * Set Usuario value
     * @param string $usuario
     * @return \StructType\AtualizarConfiguracoesTransicao
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->Usuario = $usuario;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\AtualizarConfiguracoesTransicao
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
    /**
     * Get IDSequencia value
     * @return int|null
     */
    public function getIDSequencia()
    {
        return $this->IDSequencia;
    }
    /**
     * Set IDSequencia value
     * @param int $iDSequencia
     * @return \StructType\AtualizarConfiguracoesTransicao
     */
    public function setIDSequencia($iDSequencia = null)
    {
        // validation for constraint: int
        if (!is_null($iDSequencia) && !(is_int($iDSequencia) || ctype_digit($iDSequencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDSequencia, true), gettype($iDSequencia)), __LINE__);
        }
        $this->IDSequencia = $iDSequencia;
        return $this;
    }
    /**
     * Get IdModTransicao value
     * @return int|null
     */
    public function getIdModTransicao()
    {
        return $this->IdModTransicao;
    }
    /**
     * Set IdModTransicao value
     * @param int $idModTransicao
     * @return \StructType\AtualizarConfiguracoesTransicao
     */
    public function setIdModTransicao($idModTransicao = null)
    {
        // validation for constraint: int
        if (!is_null($idModTransicao) && !(is_int($idModTransicao) || ctype_digit($idModTransicao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idModTransicao, true), gettype($idModTransicao)), __LINE__);
        }
        $this->IdModTransicao = $idModTransicao;
        return $this;
    }
    /**
     * Get Descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->Descricao;
    }
    /**
     * Set Descricao value
     * @param string $descricao
     * @return \StructType\AtualizarConfiguracoesTransicao
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->Descricao = $descricao;
        return $this;
    }
}
