<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ultima ServiceType
 * @subpackage Services
 */
class Ultima extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * UltimaMensagemFormatadaEnviadaVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UltimaMensagemFormatadaEnviadaVeiculo $parameters
     * @return \StructType\UltimaMensagemFormatadaEnviadaVeiculoResponse|bool
     */
    public function UltimaMensagemFormatadaEnviadaVeiculo(\StructType\UltimaMensagemFormatadaEnviadaVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UltimaMensagemFormatadaEnviadaVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UltimaGrupoAlvoEnviadaVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UltimaGrupoAlvoEnviadaVeiculo $parameters
     * @return \StructType\UltimaGrupoAlvoEnviadaVeiculoResponse|bool
     */
    public function UltimaGrupoAlvoEnviadaVeiculo(\StructType\UltimaGrupoAlvoEnviadaVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UltimaGrupoAlvoEnviadaVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UltimaGrupoCercaEnviadaVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UltimaGrupoCercaEnviadaVeiculo $parameters
     * @return \StructType\UltimaGrupoCercaEnviadaVeiculoResponse|bool
     */
    public function UltimaGrupoCercaEnviadaVeiculo(\StructType\UltimaGrupoCercaEnviadaVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UltimaGrupoCercaEnviadaVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UltimaGrupoRotaEnviadaVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UltimaGrupoRotaEnviadaVeiculo $parameters
     * @return \StructType\UltimaGrupoRotaEnviadaVeiculoResponse|bool
     */
    public function UltimaGrupoRotaEnviadaVeiculo(\StructType\UltimaGrupoRotaEnviadaVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UltimaGrupoRotaEnviadaVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UltimaMensagemPredefinidaEnviadaVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UltimaMensagemPredefinidaEnviadaVeiculo $parameters
     * @return \StructType\UltimaMensagemPredefinidaEnviadaVeiculoResponse|bool
     */
    public function UltimaMensagemPredefinidaEnviadaVeiculo(\StructType\UltimaMensagemPredefinidaEnviadaVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UltimaMensagemPredefinidaEnviadaVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UltimaGrupoAlvoEnviadaVeiculoResponse|\StructType\UltimaGrupoCercaEnviadaVeiculoResponse|\StructType\UltimaGrupoRotaEnviadaVeiculoResponse|\StructType\UltimaMensagemFormatadaEnviadaVeiculoResponse|\StructType\UltimaMensagemPredefinidaEnviadaVeiculoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
