<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transmitir ServiceType
 * @subpackage Services
 */
class Transmitir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TransmitirAlvo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirAlvo $parameters
     * @return \StructType\TransmitirAlvoResponse|bool
     */
    public function TransmitirAlvo(\StructType\TransmitirAlvo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirAlvo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * TransmitirConfiguracoesOpcoesSeguranca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesOpcoesSeguranca $parameters
     * @return \StructType\TransmitirConfiguracoesOpcoesSegurancaResponse|bool
     */
    public function TransmitirConfiguracoesOpcoesSeguranca(\StructType\TransmitirConfiguracoesOpcoesSeguranca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesOpcoesSeguranca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesHistorico $parameters
     * @return \StructType\TransmitirConfiguracoesHistoricoResponse|bool
     */
    public function TransmitirConfiguracoesHistorico(\StructType\TransmitirConfiguracoesHistorico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesHistorico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesExcecao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesExcecao $parameters
     * @return \StructType\TransmitirConfiguracoesExcecaoResponse|bool
     */
    public function TransmitirConfiguracoesExcecao(\StructType\TransmitirConfiguracoesExcecao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesExcecao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesAtuadores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesAtuadores $parameters
     * @return \StructType\TransmitirConfiguracoesAtuadoresResponse|bool
     */
    public function TransmitirConfiguracoesAtuadores(\StructType\TransmitirConfiguracoesAtuadores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesAtuadores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesInterativo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesInterativo $parameters
     * @return \StructType\TransmitirConfiguracoesInterativoResponse|bool
     */
    public function TransmitirConfiguracoesInterativo(\StructType\TransmitirConfiguracoesInterativo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesInterativo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesSenhas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesSenhas $parameters
     * @return \StructType\TransmitirConfiguracoesSenhasResponse|bool
     */
    public function TransmitirConfiguracoesSenhas(\StructType\TransmitirConfiguracoesSenhas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesSenhas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesTemperatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesTemperatura $parameters
     * @return \StructType\TransmitirConfiguracoesTemperaturaResponse|bool
     */
    public function TransmitirConfiguracoesTemperatura(\StructType\TransmitirConfiguracoesTemperatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesTemperatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesOpcoesSe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesOpcoesSe $parameters
     * @return \StructType\TransmitirConfiguracoesOpcoesSeResponse|bool
     */
    public function TransmitirConfiguracoesOpcoesSe(\StructType\TransmitirConfiguracoesOpcoesSe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesOpcoesSe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfguracoesTransmissao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfguracoesTransmissao $parameters
     * @return \StructType\TransmitirConfguracoesTransmissaoResponse|bool
     */
    public function TransmitirConfguracoesTransmissao(\StructType\TransmitirConfguracoesTransmissao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfguracoesTransmissao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirOperacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirOperacao $parameters
     * @return \StructType\TransmitirOperacaoResponse|bool
     */
    public function TransmitirOperacao(\StructType\TransmitirOperacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirOperacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirCerca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirCerca $parameters
     * @return \StructType\TransmitirCercaResponse|bool
     */
    public function TransmitirCerca(\StructType\TransmitirCerca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirCerca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirRota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirRota $parameters
     * @return \StructType\TransmitirRotaResponse|bool
     */
    public function TransmitirRota(\StructType\TransmitirRota $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirRota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirParametrosVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirParametrosVeiculo $parameters
     * @return \StructType\TransmitirParametrosVeiculoResponse|bool
     */
    public function TransmitirParametrosVeiculo(\StructType\TransmitirParametrosVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirParametrosVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesUmidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesUmidade $parameters
     * @return \StructType\TransmitirConfiguracoesUmidadeResponse|bool
     */
    public function TransmitirConfiguracoesUmidade(\StructType\TransmitirConfiguracoesUmidade $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesUmidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirCfgUmidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirCfgUmidade $parameters
     * @return \StructType\TransmitirCfgUmidadeResponse|bool
     */
    public function TransmitirCfgUmidade(\StructType\TransmitirCfgUmidade $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirCfgUmidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirCfgMultiplosSensores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirCfgMultiplosSensores $parameters
     * @return \StructType\TransmitirCfgMultiplosSensoresResponse|bool
     */
    public function TransmitirCfgMultiplosSensores(\StructType\TransmitirCfgMultiplosSensores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirCfgMultiplosSensores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * TransmitirConfiguracoesMultiplosSensores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesMultiplosSensores $parameters
     * @return \StructType\TransmitirConfiguracoesMultiplosSensoresResponse|bool
     */
    public function TransmitirConfiguracoesMultiplosSensores(\StructType\TransmitirConfiguracoesMultiplosSensores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesMultiplosSensores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirCfgTransmissao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirCfgTransmissao $parameters
     * @return \StructType\TransmitirCfgTransmissaoResponse|bool
     */
    public function TransmitirCfgTransmissao(\StructType\TransmitirCfgTransmissao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirCfgTransmissao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransmitirConfiguracoesIbutton
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransmitirConfiguracoesIbutton $parameters
     * @return \StructType\TransmitirConfiguracoesIbuttonResponse|bool
     */
    public function TransmitirConfiguracoesIbutton(\StructType\TransmitirConfiguracoesIbutton $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TransmitirConfiguracoesIbutton($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransmitirAlvoResponse|\StructType\TransmitirCercaResponse|\StructType\TransmitirCfgMultiplosSensoresResponse|\StructType\TransmitirCfgTransmissaoResponse|\StructType\TransmitirCfgUmidadeResponse|\StructType\TransmitirConfguracoesTransmissaoResponse|\StructType\TransmitirConfiguracoesAtuadoresResponse|\StructType\TransmitirConfiguracoesExcecaoResponse|\StructType\TransmitirConfiguracoesHistoricoResponse|\StructType\TransmitirConfiguracoesIbuttonResponse|\StructType\TransmitirConfiguracoesInterativoResponse|\StructType\TransmitirConfiguracoesMultiplosSensoresResponse|\StructType\TransmitirConfiguracoesOpcoesSegurancaResponse|\StructType\TransmitirConfiguracoesOpcoesSeResponse|\StructType\TransmitirConfiguracoesSenhasResponse|\StructType\TransmitirConfiguracoesTemperaturaResponse|\StructType\TransmitirConfiguracoesUmidadeResponse|\StructType\TransmitirOperacaoResponse|\StructType\TransmitirParametrosVeiculoResponse|\StructType\TransmitirRotaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
