<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ficha ServiceType
 * @subpackage Services
 */
class Ficha extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FichaAtivacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FichaAtivacao $parameters
     * @return \StructType\FichaAtivacaoResponse|bool
     */
    public function FichaAtivacao(\StructType\FichaAtivacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FichaAtivacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FichaAtivacaoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
