<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enviar ServiceType
 * @subpackage Services
 */
class Enviar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnviarMensagemPredefinida
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarMensagemPredefinida $parameters
     * @return \StructType\EnviarMensagemPredefinidaResponse|bool
     */
    public function EnviarMensagemPredefinida(\StructType\EnviarMensagemPredefinida $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarMensagemPredefinida($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarMensagemPreMotorista
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarMensagemPreMotorista $parameters
     * @return \StructType\EnviarMensagemPreMotoristaResponse|bool
     */
    public function EnviarMensagemPreMotorista(\StructType\EnviarMensagemPreMotorista $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarMensagemPreMotorista($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarMensagemFormatada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarMensagemFormatada $parameters
     * @return \StructType\EnviarMensagemFormatadaResponse|bool
     */
    public function EnviarMensagemFormatada(\StructType\EnviarMensagemFormatada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarMensagemFormatada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarComandoUmidadeAvulsa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarComandoUmidadeAvulsa $parameters
     * @return \StructType\EnviarComandoUmidadeAvulsaResponse|bool
     */
    public function EnviarComandoUmidadeAvulsa(\StructType\EnviarComandoUmidadeAvulsa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarComandoUmidadeAvulsa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarCfgIbuttonAntifurto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarCfgIbuttonAntifurto $parameters
     * @return \StructType\EnviarCfgIbuttonAntifurtoResponse|bool
     */
    public function EnviarCfgIbuttonAntifurto(\StructType\EnviarCfgIbuttonAntifurto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarCfgIbuttonAntifurto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnviarComandoIbuttonHabilitaIdentificacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarComandoIbuttonHabilitaIdentificacao $parameters
     * @return \StructType\EnviarComandoIbuttonHabilitaIdentificacaoResponse|bool
     */
    public function EnviarComandoIbuttonHabilitaIdentificacao(\StructType\EnviarComandoIbuttonHabilitaIdentificacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarComandoIbuttonHabilitaIdentificacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnviarComandoIbuttonConfiguraLiberacaoMotorista
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarComandoIbuttonConfiguraLiberacaoMotorista $parameters
     * @return \StructType\EnviarComandoIbuttonConfiguraLiberacaoMotoristaResponse|bool
     */
    public function EnviarComandoIbuttonConfiguraLiberacaoMotorista(\StructType\EnviarComandoIbuttonConfiguraLiberacaoMotorista $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarComandoIbuttonConfiguraLiberacaoMotorista($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao $parameters
     * @return \StructType\EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacaoResponse|bool
     */
    public function EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao(\StructType\EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnviarComandoIbuttonValidaListaIbuttons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarComandoIbuttonValidaListaIbuttons $parameters
     * @return \StructType\EnviarComandoIbuttonValidaListaIbuttonsResponse|bool
     */
    public function EnviarComandoIbuttonValidaListaIbuttons(\StructType\EnviarComandoIbuttonValidaListaIbuttons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarComandoIbuttonValidaListaIbuttons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnviarComandoIbuttonHabilitaPartida
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarComandoIbuttonHabilitaPartida $parameters
     * @return \StructType\EnviarComandoIbuttonHabilitaPartidaResponse|bool
     */
    public function EnviarComandoIbuttonHabilitaPartida(\StructType\EnviarComandoIbuttonHabilitaPartida $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarComandoIbuttonHabilitaPartida($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviarConfigOmniTelemetria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarConfigOmniTelemetria $parameters
     * @return \StructType\EnviarConfigOmniTelemetriaResponse|bool
     */
    public function EnviarConfigOmniTelemetria(\StructType\EnviarConfigOmniTelemetria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarConfigOmniTelemetria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnviarConfigFlagTrasmissaoDeEventos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarConfigFlagTrasmissaoDeEventos $parameters
     * @return \StructType\EnviarConfigFlagTrasmissaoDeEventosResponse|bool
     */
    public function EnviarConfigFlagTrasmissaoDeEventos(\StructType\EnviarConfigFlagTrasmissaoDeEventos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarConfigFlagTrasmissaoDeEventos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnviarLoteConfigFlagTrasmissaoDeEventos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarLoteConfigFlagTrasmissaoDeEventos $parameters
     * @return \StructType\EnviarLoteConfigFlagTrasmissaoDeEventosResponse|bool
     */
    public function EnviarLoteConfigFlagTrasmissaoDeEventos(\StructType\EnviarLoteConfigFlagTrasmissaoDeEventos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviarLoteConfigFlagTrasmissaoDeEventos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnviarCfgIbuttonAntifurtoResponse|\StructType\EnviarComandoIbuttonConfiguraAcaoFalhaIdentificacaoResponse|\StructType\EnviarComandoIbuttonConfiguraLiberacaoMotoristaResponse|\StructType\EnviarComandoIbuttonHabilitaIdentificacaoResponse|\StructType\EnviarComandoIbuttonHabilitaPartidaResponse|\StructType\EnviarComandoIbuttonValidaListaIbuttonsResponse|\StructType\EnviarComandoUmidadeAvulsaResponse|\StructType\EnviarConfigFlagTrasmissaoDeEventosResponse|\StructType\EnviarConfigOmniTelemetriaResponse|\StructType\EnviarLoteConfigFlagTrasmissaoDeEventosResponse|\StructType\EnviarMensagemFormatadaResponse|\StructType\EnviarMensagemPredefinidaResponse|\StructType\EnviarMensagemPreMotoristaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
