<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Envia ServiceType
 * @subpackage Services
 */
class Envia extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnviaBip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaBip $parameters
     * @return \StructType\EnviaBipResponse|bool
     */
    public function EnviaBip(\StructType\EnviaBip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaBip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnviaBipResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
